# Google Apps Script Deployment Guide

## With Your Actual Sheet IDs

✅ **All Google Sheets Created Successfully!**

## Your Google Sheets:

1. **Startup Applications**: `11iLzmCH_72gT8wyWnZygJ18KF0V1Jil7aDKVB2cLJ00`

   - 📊 [Open Sheet](https://docs.google.com/spreadsheets/d/11iLzmCH_72gT8wyWnZygJ18KF0V1Jil7aDKVB2cLJ00/edit)

2. **B2B Networking**: `1K85YoP5VJtxoR-Jd-_u1jGCYvRTkuwBpfri551xUTVQ`

   - 📊 [Open Sheet](https://docs.google.com/spreadsheets/d/1K85YoP5VJtxoR-Jd-_u1jGCYvRTkuwBpfri551xUTVQ/edit)

3. **Certification Enrollments**: `1ftAEpfBLr64EETAv1Rvj2fiT8wm38WAwVafv0bhjiRs`

   - 📊 [Open Sheet](https://docs.google.com/spreadsheets/d/1ftAEpfBLr64EETAv1Rvj2fiT8wm38WAwVafv0bhjiRs/edit)

4. **Newsletter Subscribers**: `1FKljaW5eEbhj5tJfCfEGi7QbEhq7ZfskoaPNXvyL1wU`

   - 📊 [Open Sheet](https://docs.google.com/spreadsheets/d/1FKljaW5eEbhj5tJfCfEGi7QbEhq7ZfskoaPNXvyL1wU/edit)

5. **Contact Messages**: `1sruNCthgFAJuO_-l9FOJ6yf78IMLYQRyjMkfpQ82ggM`

   - 📊 [Open Sheet](https://docs.google.com/spreadsheets/d/1sruNCthgFAJuO_-l9FOJ6yf78IMLYQRyjMkfpQ82ggM/edit)

6. **Paper Submissions**: `1p2Ftnckt-XZ2pEomfUYDpTqJroxFsDVt124JD8R2l9g`

   - 📊 [Open Sheet](https://docs.google.com/spreadsheets/d/1p2Ftnckt-XZ2pEomfUYDpTqJroxFsDVt124JD8R2l9g/edit)

7. **Event Registrations**: `1mOYIhSSxkpeUg1wlNCUcVTCUBHqRyShx5rtDv_OgkCo`
   - 📊 [Open Sheet](https://docs.google.com/spreadsheets/d/1mOYIhSSxkpeUg1wlNCUcVTCUBHqRyShx5rtDv_OgkCo/edit)

---

## 🚀 Next Steps: Deploy Google Apps Scripts

### Step 1: Create Drive Folders (for file uploads)

Create these folders in Google Drive:

1. **Pitch Decks Folder** (for startup applications)
2. **Paper Submissions Folder** (for research papers)

Copy the folder IDs and update:

- `updated-apps-script.gs` line: `var folder = DriveApp.getFolderById("YOUR_DRIVE_FOLDER_ID");`
- `paper-form-script.gs` line: `var folder = DriveApp.getFolderById("YOUR_PAPERS_FOLDER_ID");`

### Step 2: Deploy Each Apps Script

For each of the 7 scripts, follow these steps:

#### A. Startup Form (Update existing)

1. Open your existing Apps Script: `https://script.google.com/macros/s/AKfycbwqdRXDENIQtIlFNa-QQgDhjxCMAdz7XhodF6ALdvuS2WlpqVwaLSMj_oSVMlve_2qA/exec`
2. Replace code with `updated-apps-script.gs` ✅ (Sheet ID already updated)
3. Add your Drive folder ID for pitch decks

#### B. Create 6 New Apps Script Projects

For each remaining form:

1. Go to [script.google.com](https://script.google.com)
2. Click **"New Project"**
3. Copy the corresponding `.gs` file content:
   - **B2B**: `apps-scripts/b2b-form-script.gs` ✅
   - **Certification**: `apps-scripts/certification-form-script.gs` ✅
   - **Newsletter**: `apps-scripts/newsletter-form-script.gs` ✅
   - **Contact**: `apps-scripts/contact-form-script.gs` ✅
   - **Paper**: `apps-scripts/paper-form-script.gs` ✅ (Add Drive folder ID)
   - **Registration**: `apps-scripts/registration-form-script.gs` ✅
4. **Deploy as Web App**:
   - Execute as: **Me**
   - Who has access: **Anyone**
5. **Copy the deployment URL**

### Step 3: Update JavaScript URLs

After deploying all scripts, update these URLs in your `script.js`:

```javascript
// Replace these URLs with your actual deployment URLs:

// B2B Form
await fetch("YOUR_B2B_APPS_SCRIPT_URL", {...

// Certification Form
await fetch("YOUR_CERTIFICATION_APPS_SCRIPT_URL", {...

// Newsletter Form
await fetch("YOUR_NEWSLETTER_APPS_SCRIPT_URL", {...

// Contact Form
await fetch("YOUR_CONTACT_APPS_SCRIPT_URL", {...

// Paper Form
await fetch("YOUR_PAPER_APPS_SCRIPT_URL", {...

// Registration Form
await fetch("YOUR_REGISTRATION_APPS_SCRIPT_URL", {...
```

### Step 4: Test Each Form

1. **Startup Form** ✅ (Already working)
2. **B2B Form** - Test after deployment
3. **Certification Form** - Test after deployment
4. **Newsletter Form** - Test after deployment
5. **Contact Form** - Test after deployment
6. **Paper Form** - Test after deployment (with file upload)
7. **Registration Form** - Test after deployment

---

## 📋 Deployment Checklist

- ✅ **Google Sheets Created** (7/7)
- ✅ **Sheet IDs Updated in Scripts**
- ⏳ **Create Drive Folders** (2 needed)
- ⏳ **Deploy Apps Scripts** (6 new + 1 update)
- ⏳ **Update JavaScript URLs**
- ⏳ **Test All Forms**

---

## 🔧 Ready-to-Deploy Files

All files are updated with your Sheet IDs:

- ✅ `apps-scripts/b2b-form-script.gs`
- ✅ `apps-scripts/certification-form-script.gs`
- ✅ `apps-scripts/newsletter-form-script.gs`
- ✅ `apps-scripts/contact-form-script.gs`
- ✅ `apps-scripts/paper-form-script.gs`
- ✅ `apps-scripts/registration-form-script.gs`
- ✅ `updated-apps-script.gs` (startup form)

**You're ready to deploy!** 🚀
